<?PHP if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
* @package direct-as-a-service
* @subpackage models
* @filesource
*//** */

require_once APPPATH.'models/message.php';

/**
* @package direct-as-a-service
* @subpackage models
*/
class MessageStatusModel extends CI_Model {
	
   /* var $maildatabase;
	function __construct() {
        parent::__construct();
		$this->maildatabase=$this->load->database("mail_db",true);  //let's just go with the Message model's copy of the db to make sure we don't accidentally load multiple db connections
    } */
    
    function get_status($message_id) {
    	if(!empty($message_id)){
    		Message::db()->select("status_code,recipient,timestamp");
    		Message::db()->where("message_id",$message_id);    	
    		$result = Message::db()->get("message_status");
			
			if($result && $result->num_rows() > 0) {
				$statuses = array();
				foreach($result->result() as $key=>$value) {
					if (!array_key_exists($value->recipient,$statuses)){ 
						$statuses[$value->recipient] = array($value->status_code);
					}else {
						if ( $this->compare_codes($value->status_code , $statuses[$value->recipient][0])){
							array_unshift($statuses[$value->recipient], $value->status_code);
						}else{ 
							#array_push($statuses[$value->recipient], $value->status_code); //don't use array_push unless you have more than one value; better performance using operators
							$statuses[$value->recipient][] = $value->status_code;
						}
					}
				}
				return $statuses;
			}
    	}
    	#return null; //no need to explicitly do this, PHP methods default to returning null -- MG 2014-05-16
    }
	
    function message_displayed($message_id,$recipient){
    	$data = array(
    		"message_id" => $message_id,
    		"status_code" => 2,
    		"recipient" => $recipient,
    		"timestamp" =>time(),
    	);
    	Message::db()->insert("message_status",$data);
    	
    }
	private function compare_codes($a,$b){
		$order = array (0,1,5,2,3,4,100);
		return (array_search($a, $order) > array_search($b, $order));
	
	
	}
}